#ifdef GL_ES
precision mediump float;

varying	vec3 lightVector, halfVector, lightVector2;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec3 lightVector, halfVector, lightVector2;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D normalTex;
uniform sampler2D colorTex;
uniform float brightness;

void main()
{
#ifdef GL_ES
    vec3 bump = (texture2D(normalTex, vTexCoord.st).xyz * 2.0 - 1.0);
	vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec3 bump = (texture(normalTex, vTexCoord.st).xyz * 2.0 - 1.0);
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif

	float lambert = (max(0.0, dot(bump, normalize(lightVector))) + max(0.0, dot(bump, normalize(lightVector2)))) * brightness;
	
	/* red book p. 223 */
	vec3 diffuse = tColor.rgb * (lambert * 0.75);
	float specular = pow(max(0.0, dot(bump, normalize(halfVector))), 8.0) * tColor.a * 0.35;
	
	fragColor = vec4(diffuse + vec3(specular), 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
